﻿using System.Collections.Generic;
using System;
using System.Drawing;

namespace memoQSampleCMSConnector
{
    public class TestJobRequest
    {
		public string Type { get; set; }
		public Payload Payload { get; set; }
	}

	public class Payload
	{
		public int TranslationJobId { get; set; }
		public string NewStatus { get; set; }
	}

	public class ProjectCreateInfo
	{
		public string Name { get; set; }
		public string CallbackUrl { get; set; }
		public string Deadline { get; set; }
	}

	public class ProjectInfo : ProjectCreateInfo
	{
		public string ClientProjectId { get; set; }
		public string TimeCreated { get; set; }
		public string Status { get; set; }
	}
	
	public class TranslationJobCreateInfo
	{
		public string Name { get; set; }
		public string Url { get; set; }
		public string SourceLang { get; set; }
		public string TargetLang { get; set; }
        public string FileType { get; set; }
	}

	public class TranslationJobInfo : TranslationJobCreateInfo
	{
		public int TranslationJobId { get; set; }
		public string Status { get; set; }
		public string ClientProjectId { get; set; }
	}

	public class ChangeStatus
	{
		public string NewStatus { get; set; }
	}

	public class FileParameter
	{
		public byte[] File { get; set; }
		public string FileName { get; set; }
		public string ContentType { get; set; }
		public FileParameter(byte[] file) : this(file, null) { }
		public FileParameter(byte[] file, string filename) : this(file, filename, null) { }
		public FileParameter(byte[] file, string filename, string contenttype)
		{
			File = file;
			FileName = filename;
			ContentType = contenttype;
		}
	}

}

